/*----------------------------------------------------------------------------
 * Name     : rf_test.c
 * Purpose  : the APIs for BC7262 testing
 * Note(s)  : 
 *---------------------------------------------------------------------------- */
#include "string.h"
#include "rf_test.h"
#include "bc7262reg.h"
#include "bc7262.h"

uc8	ch_dnk[3][4] =
{
	{ 0x25, 0x00, 0x80, 0x08	},	//2402MHz
	{ 0x25, 0x00, 0x80, 0x0E	},	//2426MHz
	{ 0x26, 0x00, 0x00, 0x0C	},	//2480MHz
};

uc8	BER_addr[4] =
{
	0x81, 0x4A, 0xF2, 0xEE
};

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void BC7262_DirCh(u8 ch)
{
	BC7262_WriteMultiRegister(0x76, (u8 *)ch_dnk[ch], 0x04);	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void BC7262_carrier_test(u8 ch, tx_pwr_e txp)
{
	xdir_ctl_t	regv;
	
	BC7262_LightSleep();
	BC7262_TxPower(txp);
	BC7262_WriteRegister(0x15, 0x01);	//minmun deviation
	BC7262_WriteRegister(0x16, 0x00);	//
	BC7262_WriteRegister(0x02, 0x70);	//FD setting from FSCALE[15:0] register.
	BC7262_WriteRegister(0x55, 0x0E);	//
	BC7262_WriteRegister(0x71, 0x03);	//DTXD=1, DIR_EN=1
	BC7262_WriteRegister(0x74, ch);
	BC7262_WriteRegister(0x7B, 0x00);
	BC7262_TPCal();
	BC7262_VCOCal();
			
	BC7262_ReadRegister(DIR_CTRL_REQ, &regv.value);
	regv.bits.sx_en = 1;
	regv.bits.rtx_sel = 1;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);
	GCC_DELAY(200);
	regv.bits.rtx_en = 1;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void BC7262_PN9_test(u8 ch, tx_pwr_e txp)
{
	xdir_ctl_t	regv;
	
	BC7262_LightSleep();
	BC7262_TxPower(txp);
	BC7262_WriteRegister(0x02, 0x30);	//FD setting from USER_DR[2:0] register. register.
	BC7262_WriteRegister(0x55, 0x61);	
	BC7262_WriteRegister(0x71, 0x03);	//DTXD=1, DIR_EN=1
	BC7262_WriteRegister(0x74, ch);
	BC7262_WriteRegister(0x7B, 0x10);
	BC7262_TPCal();
	BC7262_VCOCal();

	BC7262_ReadRegister(DIR_CTRL_REQ, &regv.value);
	regv.bits.sx_en = 1;
	regv.bits.rtx_sel = 1;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);
	GCC_DELAY(200);
	regv.bits.rtx_en = 1;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);		
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void BC7262_BER_test(u8 ch)
{
	xdir_ctl_t	regv;
	u8	tmp_buf[4];
	
	BC7262_LightSleep();
//	BC7262_WriteRegister(GIO_CTL_REG, (TXD_OUTPUT<<4)+TBCLK_OUTPUT);
	BC7262_WriteRegister(GIO_CTL_REG, (TXD_OUTPUT<<4)+INPUT_MODE);
	BC7262_WriteRegister(GIOPU_CTL_REG, 0x7D);
	BC7262_WriteRegister(GIOPU_DRV_REG, 0x5F);	//1mA
	BC7262_WriteRegister(0x55, 0x12);	//default	
	BC7262_WriteRegister(0x71, 0x01);	//DTXD=0, DIR_EN=1
	BC7262_WriteRegister(0x75, ch);
	BC7262_WriteRegister(0x7B, 0x00);
	BC7262_TPCal();
	BC7262_VCOCal();
	
	memcpy((void *)tmp_buf, BER_addr, sizeof(BER_addr));
	BC7262_WriteAccAddr((u8 *)tmp_buf);
			
	BC7262_ReadRegister(DIR_CTRL_REQ, &regv.value);
	regv.bits.sx_en = 1;
	regv.bits.rtx_sel = 0;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);
	GCC_DELAY(200);
	regv.bits.rtx_en = 1;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void BC7262_start_tx_dir(void)
{
	xdir_ctl_t	regv;
	
	BC7262_ReadRegister(DIR_CTRL_REQ, &regv.value);
	regv.bits.sx_en = 1;
	regv.bits.rtx_sel = 1;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);
	GCC_DELAY(200);
	regv.bits.rtx_en = 1;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);	
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void BC7262_stop_dir(void)
{
	xdir_ctl_t	regv;
	
	BC7262_ReadRegister(DIR_CTRL_REQ, &regv.value);
	
	regv.bits.rtx_en = 0;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);	
	regv.bits.sx_en = 0;
	BC7262_WriteRegister(DIR_CTRL_REQ, regv.value);
}

